![Mollie](https://www.mollie.nl/files/Mollie-Logo-Style-Small.png)

# Process realtime status updates with a webhook
A webhook is a URL Mollie will call when an object’s status changes, for example when a payment changes from `open` to `paid`. More specifics can be found in [the webhook guide](https://docs.mollie.com/guides/webhooks).

To implement the webhook in your Laravel application you need to provide a `webhookUrl` parameter when creating a payment (or subscription):

```php
$payment = Mollie::api()->payments()->create([
    'amount' => [
        'currency' => 'EUR',
        'value' => '10.00', // You must send the correct number of decimals, thus we enforce the use of strings
    ],
    'description' => 'My first API payment',
    'redirectUrl' => 'https://webshop.example.org/order/12345/',
    'webhookUrl'   => route('webhooks.mollie'),
]);
```

And create a matching route and controller for the webhook in your application:

```php
// routes/web.php

Route::name('webhooks.mollie')->post('webhooks/mollie', 'MollieWebhookController@handle');
```

```php
// App/Http/Controllers/MollieWebhookController.php

class MollieWebhookController extends Controller {
    public function handle(Request $request) {
        if (! $request->has('id')) {
            return;
        }

        $payment = Mollie::api()->payments()->get($request->id);

        if ($payment->isPaid()) {
            // do your thing...
        }
    }
}
```

Finally, it is _strongly advised_ to disable the `VerifyCsrfToken` middleware, which is included in the `web` middleware group by default. (Out of the box, Laravel applies the `web` middleware group to all routes in `routes/web.php`.)

You can exclude URIs from the CSRF protection in the `app/Http/Middleware/VerifyCsrfToken.php` file:

```php
/**
 * The URIs that should be excluded from CSRF verification.
 *
 * @var array
 */
protected $except = [
    'webhooks/mollie'
];
```

If this solution does not work, open an [issue](https://github.com/mollie/laravel-mollie/issues) so we can assist you.
